#include "nexgendash.h"
#include "Menu.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>

/*void MenuList::AddNode (PMenuNode newitem) {
	PMenuNode MenuCurr = MenuHead;
	while(MenuCurr!=NULL) {
		if(strcmp(MenuCurr->Title, newitem->Title) > 0) {
			if(MenuCurr->Prev!=NULL) {
				newitem->Prev = MenuCurr->Prev;
				newitem->Prev->Next = newitem;
			}
			if(MenuCurr->Next!=NULL) {
				newitem->Next = MenuCurr;
				newitem->Next->Prev = newitem;
			}
			if(MenuCurr==MenuHead) MenuHead = newitem;
			return;
		}
		MenuCurr=MenuCurr->Next;
	}

	if(MenuTail!=NULL) {
		newitem->Prev = MenuTail;
		newitem->Prev->Next = newitem;
		MenuTail = newitem;
	}
}*/

void MenuList::AddNode (PMenuNode newitem) {
	PMenuNode MenuCurr = MenuHead;
	// If the menu is NULL set it to newitem
	if (MenuCurr==NULL) {
		MenuHead = newitem;
		return;
	}
	while(MenuCurr->Next!=NULL) {
		if(strcmp(MenuCurr->Title, newitem->Title) > 0) {
			if(MenuCurr->Prev!=NULL) {
				newitem->Prev = MenuCurr->Prev;
				newitem->Prev->Next = newitem;
			}
			if(MenuCurr->Next!=NULL) {
				newitem->Next = MenuCurr;
				newitem->Next->Prev = newitem;
			}
			if(MenuCurr==MenuHead) MenuHead = newitem;
			return;
		}
		MenuCurr=MenuCurr->Next;
	}
	// Reached the end and didnt find anywhere to add the newitem
	// so add it to the end
	newitem->Prev = MenuCurr;
	newitem->Prev->Next = newitem;
	return;
}

PMenuNode MenuList::FindNode (const char *name) {
	for(PMenuNode node=MenuHead; node!=NULL; node=node->Next) {
		if(!strcmp(name,node->Title))
			return node;
	}
	return NULL;
}

void MenuList::Clear () {
}

void MenuList::Rename (char* str) {
	strncpy(MenuName, str, 255);
}

char* MenuList::GetName () {
	return (char*)MenuName;
}

/*PMenuNode MenuList::AddXBE (char *filename) {
	DWORD baseaddr, certaddr, cert_id;
	WCHAR cert_string[41];

	HANDLE xbefd=CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_RANDOM_ACCESS, NULL);
	if(xbefd!=INVALID_HANDLE_VALUE) {
		DWORD readin;

		SetFilePointer(xbefd, 0x104, NULL, FILE_BEGIN);
		ReadFile(xbefd, &baseaddr, 0x4, &readin, NULL);

		SetFilePointer(xbefd, 0x118, NULL, FILE_BEGIN);
		ReadFile(xbefd, &certaddr, 0x4, &readin, NULL);

		SetFilePointer(xbefd, (certaddr-baseaddr)+0x8, NULL, FILE_BEGIN);
		ReadFile(xbefd, &cert_id, 0x4, &readin, NULL);

		SetFilePointer(xbefd, (certaddr-baseaddr)+0xc, NULL, FILE_BEGIN);
		ReadFile(xbefd, &cert_string, 0x50, &readin, NULL);
	
		cert_string[0x50]=0x0000;

		CloseHandle(xbefd);

		PMenuNode newitem = new MenuNode;
		if(newitem!=NULL) {
			int added=0;
			newitem->TitleID=cert_id;
			sprintf(newitem->File, "%s", filename);
			if(!added) {
				int x=lstrlenW(cert_string);
				if(x==0) {
					strcpy(newitem->Title, "Unknown Title");
				} else if(x<44) {
					sprintf(newitem->Title, "%S", cert_string);
				} else {
					WCHAR tstr[33];
					lstrcpynW(tstr, cert_string, 32);
					sprintf(newitem->Title, "%S...", tstr);
				}
			}

			{
				char * idtmp = strdup(filename);
				char * imtmp = strrchr(idtmp, '\\');
				imtmp[0]=0;
				newitem->DBlocks = XGetDisplayBlocks(idtmp);
				free(idtmp);
			}

//			sprintf(newitem->Icon, "E:\\UDATA\\%08x\\TitleImage.xbx", cert_id);
			sprintf(newitem->Icon, "STORAGE:\\UDATA\\%08x\\TitleImage.xbx", cert_id);

		}
	}

	OutputDebugString("Error adding ");
	OutputDebugString(filename);
	OutputDebugString("to a list.\n");

	return NULL;
}*/

// Check TitleImage.xbx Exsists
BOOL  FileFound( LPCTSTR szFilename )
{
	BOOL bReturn = FALSE;
	DWORD dwAttributes;

		if ( !bReturn )
		{
			dwAttributes = GetFileAttributes( szFilename );
			if ( dwAttributes != (DWORD)-1 )
			{
				bReturn = TRUE;
			}
		}

	return bReturn;
}

//End FileFound

PMenuNode MenuList::AddXBE (char *filename) {
	DWORD baseaddr, certaddr, cert_id;
	WCHAR cert_string[41];

	char *path = new char[MAX_PATH];

	HANDLE xbefd=CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL,
OPEN_EXISTING, FILE_FLAG_RANDOM_ACCESS, NULL);
	if(xbefd!=INVALID_HANDLE_VALUE) {
		DWORD readin;

		SetFilePointer(xbefd, 0x104, NULL, FILE_BEGIN);
		ReadFile(xbefd, &baseaddr, 0x4, &readin, NULL);

		SetFilePointer(xbefd, 0x118, NULL, FILE_BEGIN);
		ReadFile(xbefd, &certaddr, 0x4, &readin, NULL);

		SetFilePointer(xbefd, (certaddr-baseaddr)+0x8, NULL, FILE_BEGIN);
		ReadFile(xbefd, &cert_id, 0x4, &readin, NULL);

		SetFilePointer(xbefd, (certaddr-baseaddr)+0xc, NULL, FILE_BEGIN);
		ReadFile(xbefd, &cert_string, 0x50, &readin, NULL);

		cert_string[0x50]=0x0000;

		CloseHandle(xbefd);

		PMenuNode newitem = new MenuNode;
		if(newitem!=NULL) {
			int added=0;
			newitem->TitleID=cert_id;
			sprintf(newitem->File, "%s", filename);
			if(!added) {
				int x=lstrlenW(cert_string);
				if(x==0) {
					//strcpy(newitem->Title, "Unknown Title");
					strcpy(newitem->Title, FolderNameFromFilePAthA(filename));
				} else if(x<44) {
					sprintf(newitem->Title, "%S", cert_string);
				} else {
					WCHAR tstr[33];
					lstrcpynW(tstr, cert_string, 32);
					sprintf(newitem->Title, "%S...", tstr);
				}
			}

			{
				char * idtmp = strdup(filename);
				char * imtmp = strrchr(idtmp, '\\');
				imtmp[0]=0;
				newitem->DBlocks = XGetDisplayBlocks(idtmp);
				free(idtmp);
			}

			//Search XBE Path 1st.
			strcpy(path, PathFromFilePathA(filename));
			sprintf(newitem->Icon, "%s\\TitleImage.xbx", path);
			if ( !FileFound( newitem->Icon ) )
			{
				//No TitleImage.xbx found in app path look in app's UDATA folder.
				//sprintf(newitem->Icon, "E:\\UDATA\\%08x\\TitleImage.xbx", cert_id);
				sprintf(newitem->Icon, "STORAGE:\\UDATA\\%08x\\TitleImage.xbx", cert_id);

				if ( !FileFound( newitem->Icon ) )
				{
				//No TitleImage.xbx found load neXgen's TitleImage.xbx
				sprintf(newitem->Icon, "U:\\TitleImage.xbx");
				}

			}

		}
		// Add the newitem to the MenuHead node
		AddNode(newitem);
		// not sure if return is needed will need to test
		return newitem;
	} else {
		OutputDebugString("Error adding ");
		OutputDebugString(filename);
		OutputDebugString("to a list.\n");
		return NULL;
	}
}

PMenuNode MenuList::AddFile (char *filename) {
	PMenuNode newitem = new MenuNode;
	if(newitem!=NULL) {
		strcpy(newitem->File, filename);
		if(char *c=strrchr(filename,'\\')) {
			c++;
			strcpy(newitem->Title, c);
		} else
			strcpy(newitem->Title, filename);

		HANDLE fd=CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_RANDOM_ACCESS, NULL);
		if(fd!=INVALID_HANDLE_VALUE) {
			newitem->DBlocks=GetFileSize(fd, NULL);
			CloseHandle(fd);
		}

		AddNode(newitem);

		return newitem;
	}
	return NULL;
}


PMenuNode MenuList::AddURL (char *url, DWORD size, int type) {
	PMenuNode newitem = new MenuNode;
	if(newitem!=NULL) {
		if(char *c=strrchr(url,'/')) {
			c++;
			if(type)
				sprintf(newitem->Title, "[%s]", c);
			else
				strcpy(newitem->Title, c);
		} else {
			if(type)
				sprintf(newitem->Title, "[%s]", url);
			else
				strcpy(newitem->Title, url);
		}
		strcpy(newitem->File, url);
		newitem->DBlocks=size;
		newitem->Action=type;

		AddNode(newitem);

		return newitem;
	}
	return NULL;
}

void MenuList::AddFiles(const char *where, const char *filter, int norecursion) {
	int u,w,z=0;
	WIN32_FIND_DATA fd;
	HANDLE hFD;

	char *tmpc = new char[MAX_PATH];
	char *tmpb = new char[MAX_PATH];
	char **paths = new char*[128];
	for(z=0; z<128; z++) paths[z] = new char[MAX_PATH];

	if(where==NULL) {
		return;
	}

	if(!norecursion) {
		strcpy(tmpb, where);
		sprintf(tmpc, "%s\\*", where);
		if((hFD=FindFirstFile(tmpc, &fd))!=INVALID_HANDLE_VALUE) {
			for(z=0;z<128;) {
				if(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
					sprintf(paths[z], "%s\\%s", tmpb, fd.cFileName);
					z++;
				}
	
				if(!FindNextFile(hFD, &fd)) {
					FindClose(hFD);
					break;
				}
			}
		} else {
			DWORD Err= GetLastError();
			return;
		}
	} else {
		strcpy(paths[0], where);
		z=1;
	}

	w=0;
	if(z>0) for(u=0; u<z; u++) {
		if(w==0) {
			if(filter!=NULL)
				sprintf(tmpc, "%s\\%s", paths[u], filter);
			else
				sprintf(tmpc, "%s\\default.xbe", paths[u]);
			DbgPrintf("Finding files matching %s\n", tmpc);
			if((hFD=FindFirstFile(tmpc, &fd))!=INVALID_HANDLE_VALUE)
				w=1;
		}
		while(w==1) {
			sprintf(tmpb, "%s\\%s", paths[u], fd.cFileName);
			DbgPrintf("Found %s\n", tmpb);
			if(!filter || !strcmp(filter, "*.xbe"))
				AddXBE(tmpb);
			else
				AddFile(tmpb);

			if(!FindNextFile(hFD, &fd))
				w=2;
		}

		if(w==2) {
			FindClose(hFD);
			w=0;
		}
	}
}

int MenuList::NodeCount() {
	int i=0;
	PMenuNode MenuCurr = MenuHead;
	while(MenuCurr!=NULL) {
		MenuCurr=MenuCurr->Next;
		i++;
	}
	return i;
}

int MenuList::IndexList() {
	int i = NodeCount();
	if (IndexedMenu!=NULL) delete IndexedMenu;
	IndexedMenu = new PMenuNode[i];
	PMenuNode MenuCurr = MenuHead;
	for(i=0, MenuCurr=MenuHead; MenuCurr!=NULL; i++, MenuCurr=MenuCurr->Next)
		IndexedMenu[i]=MenuCurr;
	return i;
}

MenuList::MenuList() {
	strcpy(MenuName, "Untitled Menu");
	MenuHead=NULL;
	MenuTail=NULL;
	IndexedMenu=NULL;
}

MenuList::~MenuList() {
	for(int i=NodeCount(); i>0; i--)
		delete IndexedMenu[i];
	delete IndexedMenu;
}
